using System;
using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Config;
using inetsoftware.Pdfc.Results;
using System.Collections.Generic;
using inetsoftware.Pdfc.Presenter;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample to show the modifications between 2 PDF files in a type-sorted list.
    /// Expects 2 arguments - the paths of the PDF files
    /// </summary>
    public class OutputSpecifyModifyTypes
    {
        static OutputSpecifyModifyTypes()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show the modifications between 2 PDF files in a type-sorted list.
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args)
        {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            PDFComparer pdfComparer = new PDFComparer();
            pdfComparer.AddPresenter(new ConsolePresenter());
            IDictionary<string, string> profile = new Dictionary<string, string>();

            System.Console.WriteLine("all modified texts");
            profile[PDFCProperty.COMPARE_TYPES] = "TEXT";
            pdfComparer.SetProfile(profile).Compare(args[0], args[1]).Dispose();

            System.Console.WriteLine("\nall modified lines");
            profile[PDFCProperty.COMPARE_TYPES] = "LINE";
            pdfComparer.SetProfile(profile).Compare(args[0], args[1]).Dispose();

            System.Console.WriteLine("\nall modified images");
            profile[PDFCProperty.COMPARE_TYPES] = "IMAGE";
            pdfComparer.SetProfile(profile).Compare(args[0], args[1]).Dispose();
        }
    }
}
